-------------------------------------------------------------------------------
--
-- Copyright(C) 2004 Xilinx, Inc. All rights reserved.
--
-- This text contains proprietary, confidential information of Xilinx, Inc.,
-- is distributed under license from Xilinx, Inc., and may be used, copied
-- and/or disclosed only pursuant to the terms of a valid license agreement
-- with Xilinx, Inc.
--
-- This copyright notice must be retained as part of this text at all times.
--
-- $Header: /devl/xcs/repo/env/Databases/ip/src2/J/addr_gen_802_16e_v2_1/simulation/addr_gen_802_16e_v2_1_comp.vhd,v 1.7 2008/09/09 19:55:31 akennedy Exp $
--
-------------------------------------------------------------------------------
-- Unit     :
-- Function :
-- Author   : Stephen Creaney
-------------------------------------------------------------------------------
-- Description:
--
-- Top level component statement for core.
--
-------------------------------------------------------------------------------

library std;
use std.textio.all;

library ieee;
use ieee.std_logic_1164.all;

-- Note cannot use XilinxCoreLib because XST doesn't know what that is.
-- Modelsim can either map addr_gen_802_16e_v2_1 to xilinxcorelib (to get the
-- true bhv model) or to a separate addr_gen_802_16e_v2_1 library that contains
-- all the core source files (if no true bhv model exists).
--library addr_gen_802_16e_v2_1;
--use addr_gen_802_16e_v2_1.addr_gen_802_16e_intlv_pkg.all;

package addr_gen_802_16e_v2_1_comp is

  component addr_gen_802_16e_v2_1 is
    generic (
      C_ADDR_WIDTH    : integer := 12;
      C_HAS_ACLR      : integer := 0;
      C_HAS_CE        : integer := 0;
      C_HAS_OP_NEXT   : integer := 1;
      C_HAS_SCLR      : integer := 1;
      C_HAS_START_ENC : integer := 1;
      C_MODE          : integer := 2;
      C_USE_BASEBLOX  : integer := 0
      );
    port (
      -- System CLK, ACLR, SCLR and CE
      CLK             : in  std_logic;
      ACLR            : in  std_logic;
      SCLR            : in  std_logic;
      CE              : in  std_logic;
      -- Input
      START           : in  std_logic;
      BLK_SEL         : in  std_logic_vector(4 downto 0);
      -- Ouput
      OP_NEXT         : out std_logic;
      START_ENC       : out std_logic;
      ADDR            : out std_logic_vector(c_addr_width-1 downto 0)
      );
  end component; -- addr_gen_802_16e_v2_1

-- The following tells XST that addr_gen_802_16e_v2_1 is a black box which  
-- should be generated by the command given by the value of this attribute
-- Note the fully qualified SIM (JAVA class) name that forms the 
-- basis of the core.
attribute box_type : string; 
attribute box_type of addr_gen_802_16e_v2_1 : component is "black_box"; 
attribute GENERATOR_DEFAULT : string; 
attribute GENERATOR_DEFAULT of addr_gen_802_16e_v2_1 : component is 
          "generatecore -v com.xilinx.ip.addr_gen_802_16e_v2_1.addr_gen_802_16e_v2_1";

end package  addr_gen_802_16e_v2_1_comp;
